/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.trains.display.GlobalTrainDisplayData;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.graph.DiscoveredPath;
import com.zurrtum.create.content.trains.schedule.Schedule;
import com.zurrtum.create.content.trains.schedule.ScheduleEntry;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.zurrtum.create.content.trains.schedule.condition.ScheduledDelay;
import com.zurrtum.create.content.trains.schedule.destination.ChangeTitleInstruction;
import com.zurrtum.create.content.trains.schedule.destination.DestinationInstruction;
import com.zurrtum.create.content.trains.schedule.destination.ScheduleInstruction;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

public class ScheduleRuntime {
    private static final int TBD = -1;
    private static final int INVALID = -2;
    public Train train;
    public Schedule schedule;
    public boolean isAutoSchedule;
    public boolean paused;
    public boolean completed;
    public int currentEntry;
    public State state;
    public List<Integer> conditionProgress;
    public List<class_2487> conditionContext;
    public String currentTitle;
    public int ticksInTransit;
    public List<Integer> predictionTicks;
    public boolean displayLinkUpdateRequested;
    private static final int INTERVAL = 40;
    private int cooldown;

    public ScheduleRuntime(Train train) {
        this.train = train;
        this.reset();
    }

    public void startCooldown() {
        this.cooldown = 40;
    }

    public void destinationReached() {
        if (this.state != State.IN_TRANSIT) {
            return;
        }
        this.state = State.POST_TRANSIT;
        this.conditionProgress.clear();
        this.conditionContext.clear();
        this.displayLinkUpdateRequested = true;
        for (Carriage carriage : this.train.carriages) {
            carriage.storage.resetIdleCargoTracker();
        }
        if (this.ticksInTransit > 0) {
            int current = this.predictionTicks.get(this.currentEntry);
            if (current > 0) {
                this.ticksInTransit = (current + this.ticksInTransit) / 2;
            }
            this.predictionTicks.set(this.currentEntry, this.ticksInTransit);
        }
        if (this.currentEntry >= this.schedule.entries.size()) {
            return;
        }
        List<List<ScheduleWaitCondition>> conditions = this.schedule.entries.get((int)this.currentEntry).conditions;
        for (int i = 0; i < conditions.size(); ++i) {
            this.conditionProgress.add(0);
            this.conditionContext.add(new class_2487());
        }
    }

    public void transitInterrupted() {
        if (this.schedule == null || this.state != State.IN_TRANSIT) {
            return;
        }
        this.state = State.PRE_TRANSIT;
        this.cooldown = 0;
    }

    public void tick(class_1937 level) {
        if (this.schedule == null) {
            return;
        }
        if (this.paused) {
            return;
        }
        if (this.train.derailed) {
            return;
        }
        if (this.train.navigation.destination != null) {
            ++this.ticksInTransit;
            return;
        }
        if (this.checkEndOfScheduleReached()) {
            return;
        }
        if (this.cooldown-- > 0) {
            return;
        }
        if (this.state == State.IN_TRANSIT) {
            return;
        }
        if (this.state == State.POST_TRANSIT) {
            this.tickConditions(level);
            return;
        }
        DiscoveredPath nextPath = this.startCurrentInstruction(level);
        if (nextPath == null) {
            return;
        }
        this.train.status.successfulNavigation();
        if (nextPath.destination == this.train.getCurrentStation()) {
            this.state = State.IN_TRANSIT;
            this.destinationReached();
            return;
        }
        if (this.train.navigation.startNavigation(nextPath) != -1.0) {
            this.state = State.IN_TRANSIT;
            this.ticksInTransit = 0;
        }
    }

    private boolean checkEndOfScheduleReached() {
        if (this.currentEntry < this.schedule.entries.size()) {
            return false;
        }
        this.currentEntry = 0;
        if (!this.schedule.cyclic) {
            this.paused = true;
            this.completed = true;
        }
        return true;
    }

    public void tickConditions(class_1937 level) {
        ScheduleEntry entry = this.schedule.entries.get(this.currentEntry);
        List<List<ScheduleWaitCondition>> conditions = entry.conditions;
        if (!entry.instruction.supportsConditions()) {
            this.state = State.PRE_TRANSIT;
            ++this.currentEntry;
            return;
        }
        for (int i = 0; i < conditions.size(); ++i) {
            List<ScheduleWaitCondition> list = conditions.get(i);
            int progress = this.conditionProgress.get(i);
            if (progress >= list.size()) {
                this.state = State.PRE_TRANSIT;
                ++this.currentEntry;
                return;
            }
            class_2487 tag = this.conditionContext.get(i);
            ScheduleWaitCondition condition = list.get(progress);
            int prevVersion = tag.method_68083("StatusVersion", 0);
            if (condition.tickCompletion(level, this.train, tag)) {
                this.conditionContext.set(i, new class_2487());
                this.conditionProgress.set(i, progress + 1);
                this.displayLinkUpdateRequested |= i == 0;
            }
            this.displayLinkUpdateRequested |= i == 0 && prevVersion != tag.method_68083("StatusVersion", 0);
        }
        for (Carriage carriage : this.train.carriages) {
            carriage.storage.tickIdleCargoTracker();
        }
    }

    public DiscoveredPath startCurrentInstruction(class_1937 level) {
        if (this.checkEndOfScheduleReached()) {
            return null;
        }
        ScheduleEntry entry = this.schedule.entries.get(this.currentEntry);
        ScheduleInstruction instruction = entry.instruction;
        return instruction.start(this, level);
    }

    public void setSchedule(Schedule schedule, boolean auto) {
        this.reset();
        this.schedule = schedule;
        this.currentEntry = class_3532.method_15340((int)schedule.savedProgress, (int)0, (int)(schedule.entries.size() - 1));
        this.paused = false;
        this.isAutoSchedule = auto;
        this.train.status.newSchedule();
        this.predictionTicks = new ArrayList<Integer>();
        schedule.entries.forEach($ -> this.predictionTicks.add(-1));
        this.displayLinkUpdateRequested = true;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void discardSchedule() {
        this.train.navigation.cancelNavigation();
        this.reset();
    }

    private void reset() {
        this.paused = true;
        this.completed = false;
        this.isAutoSchedule = false;
        this.currentEntry = 0;
        this.currentTitle = "";
        this.schedule = null;
        this.state = State.PRE_TRANSIT;
        this.conditionProgress = new ArrayList<Integer>();
        this.conditionContext = new ArrayList<class_2487>();
        this.predictionTicks = new ArrayList<Integer>();
    }

    public Collection<GlobalTrainDisplayData.TrainDeparturePrediction> submitPredictions() {
        int index;
        ArrayList<GlobalTrainDisplayData.TrainDeparturePrediction> predictions = new ArrayList<GlobalTrainDisplayData.TrainDeparturePrediction>();
        int entryCount = this.schedule.entries.size();
        int accumulatedTime = 0;
        int current = this.currentEntry;
        if (this.state == State.POST_TRANSIT || current >= entryCount) {
            int departureTime;
            GlobalStation currentStation = this.train.getCurrentStation();
            if (currentStation != null) {
                predictions.add(this.createPrediction(current, currentStation.name, this.currentTitle, 0));
            }
            accumulatedTime = (departureTime = this.estimateStayDuration(current)) == -2 ? -2 : (accumulatedTime += departureTime);
        } else {
            GlobalStation destination = this.train.navigation.destination;
            if (destination != null) {
                float predictedTime;
                double speed = Math.min(this.train.throttle * (double)this.train.maxSpeed(), (double)((this.train.maxSpeed() + this.train.maxTurnSpeed()) / 2.0f));
                int timeRemaining = (int)(this.train.navigation.distanceToDestination / speed) * 2;
                if (this.predictionTicks.size() > current && this.train.navigation.distanceStartedAt != 0.0 && (predictedTime = (float)this.predictionTicks.get(current).intValue()) > 0.0f) {
                    predictedTime = (float)((double)predictedTime * class_3532.method_15350((double)(this.train.navigation.distanceToDestination / this.train.navigation.distanceStartedAt), (double)0.0, (double)1.0));
                    timeRemaining = (timeRemaining + (int)predictedTime) / 2;
                }
                predictions.add(this.createPrediction(current, destination.name, this.currentTitle, accumulatedTime += timeRemaining));
                int departureTime = this.estimateStayDuration(current);
                accumulatedTime = departureTime != -2 ? (accumulatedTime += departureTime) : -2;
            } else {
                this.predictForEntry(current, this.currentTitle, accumulatedTime, predictions);
            }
        }
        String currentTitle = this.currentTitle;
        for (int i = 1; i < entryCount && ((index = (i + current) % entryCount) != 0 || this.schedule.cyclic); ++i) {
            ScheduleInstruction scheduleInstruction = this.schedule.entries.get((int)index).instruction;
            if (scheduleInstruction instanceof ChangeTitleInstruction) {
                ChangeTitleInstruction title = (ChangeTitleInstruction)scheduleInstruction;
                currentTitle = title.getScheduleTitle();
                continue;
            }
            accumulatedTime = this.predictForEntry(index, currentTitle, accumulatedTime, predictions);
        }
        predictions.removeIf(Objects::isNull);
        return predictions;
    }

    private int predictForEntry(int index, String currentTitle, int accumulatedTime, Collection<GlobalTrainDisplayData.TrainDeparturePrediction> predictions) {
        ScheduleEntry entry = this.schedule.entries.get(index);
        ScheduleInstruction scheduleInstruction = entry.instruction;
        if (!(scheduleInstruction instanceof DestinationInstruction)) {
            return accumulatedTime;
        }
        DestinationInstruction filter = (DestinationInstruction)scheduleInstruction;
        if (this.predictionTicks.size() <= this.currentEntry) {
            return accumulatedTime;
        }
        int departureTime = this.estimateStayDuration(index);
        if (accumulatedTime < 0) {
            predictions.add(this.createPrediction(index, filter.getFilter(), currentTitle, accumulatedTime));
            return Math.min(accumulatedTime, departureTime);
        }
        int predictedTime = this.predictionTicks.get(index);
        accumulatedTime += predictedTime;
        if (predictedTime == -1) {
            accumulatedTime = -1;
        }
        predictions.add(this.createPrediction(index, filter.getFilter(), currentTitle, accumulatedTime));
        if (accumulatedTime != -1) {
            accumulatedTime += departureTime;
        }
        if (departureTime == -2) {
            accumulatedTime = -2;
        }
        return accumulatedTime;
    }

    private int estimateStayDuration(int index) {
        if (index >= this.schedule.entries.size()) {
            if (!this.schedule.cyclic) {
                return -2;
            }
            index = 0;
        }
        ScheduleEntry scheduleEntry = this.schedule.entries.get(index);
        block0: for (List<ScheduleWaitCondition> list : scheduleEntry.conditions) {
            int total = 0;
            for (ScheduleWaitCondition condition : list) {
                if (!(condition instanceof ScheduledDelay)) continue block0;
                ScheduledDelay wait = (ScheduledDelay)condition;
                total += wait.totalWaitTicks();
            }
            return total;
        }
        return -2;
    }

    private GlobalTrainDisplayData.TrainDeparturePrediction createPrediction(int index, String destination, String currentTitle, int time) {
        String text;
        if (time == -2) {
            return null;
        }
        int size = this.schedule.entries.size();
        if (index >= size) {
            if (!this.schedule.cyclic) {
                return new GlobalTrainDisplayData.TrainDeparturePrediction(this.train, time, class_5244.method_48320(), destination);
            }
            index %= size;
        }
        if ((text = currentTitle).isBlank()) {
            for (int i = 1; i < size; ++i) {
                int j = (index + i) % size;
                ScheduleEntry scheduleEntry = this.schedule.entries.get(j);
                ScheduleInstruction scheduleInstruction = scheduleEntry.instruction;
                if (!(scheduleInstruction instanceof DestinationInstruction)) continue;
                DestinationInstruction instruction = (DestinationInstruction)scheduleInstruction;
                text = instruction.getFilter().replaceAll("\\*", "").trim();
                break;
            }
        }
        return new GlobalTrainDisplayData.TrainDeparturePrediction(this.train, time, class_2561.method_43470((String)text), destination);
    }

    public void write(class_11372 view) {
        view.method_71465("CurrentEntry", this.currentEntry);
        view.method_71472("AutoSchedule", this.isAutoSchedule);
        view.method_71472("Paused", this.paused);
        view.method_71472("Completed", this.completed);
        if (this.schedule != null) {
            this.schedule.write(view.method_71461("Schedule"));
        }
        view.method_71468("State", State.CODEC, (Object)this.state);
        view.method_71473("ConditionProgress", this.conditionProgress.stream().mapToInt(Integer::intValue).toArray());
        view.method_71468("ConditionContext", CreateCodecs.NBT_COMPOUND_LIST_CODEC, this.conditionContext);
        view.method_71473("TransitTimes", this.predictionTicks.stream().mapToInt(Integer::intValue).toArray());
    }

    public static <T> DataResult<T> encode(ScheduleRuntime input, DynamicOps<T> ops, T empty) {
        RecordBuilder map = ops.mapBuilder();
        map.add("CurrentEntry", ops.createInt(input.currentEntry));
        map.add("AutoSchedule", ops.createBoolean(input.isAutoSchedule));
        map.add("Paused", ops.createBoolean(input.paused));
        map.add("Completed", ops.createBoolean(input.completed));
        if (input.schedule != null) {
            map.add("Schedule", Schedule.encode(input.schedule, ops, empty));
        }
        map.add("State", (Object)input.state, State.CODEC);
        map.add("ConditionProgress", ops.createIntList(input.conditionProgress.stream().mapToInt(Integer::intValue)));
        map.add("ConditionContext", input.conditionContext, CreateCodecs.NBT_COMPOUND_LIST_CODEC);
        map.add("TransitTimes", ops.createIntList(input.predictionTicks.stream().mapToInt(Integer::intValue)));
        return map.build(empty);
    }

    public void read(class_11368 view) {
        this.reset();
        this.paused = view.method_71433("Paused", false);
        this.completed = view.method_71433("Completed", false);
        this.isAutoSchedule = view.method_71433("AutoSchedule", false);
        this.currentEntry = Math.max(0, view.method_71424("CurrentEntry", 0));
        view.method_71420("Schedule").ifPresent(scheduleView -> {
            this.schedule = Schedule.read(scheduleView);
        });
        this.state = view.method_71426("State", State.CODEC).orElse(State.PRE_TRANSIT);
        view.method_71442("ConditionProgress").ifPresent(array -> {
            for (int i : array) {
                this.conditionProgress.add(i);
            }
        });
        view.method_71426("ConditionContext", CreateCodecs.NBT_COMPOUND_LIST_CODEC).ifPresent(this.conditionContext::addAll);
        if (this.schedule != null) {
            this.schedule.entries.forEach($ -> this.predictionTicks.add(-1));
            view.method_71442("TransitTimes").ifPresent(readTransits -> {
                if (((int[])readTransits).length == this.schedule.entries.size()) {
                    for (int i = 0; i < ((int[])readTransits).length; ++i) {
                        this.predictionTicks.set(i, readTransits[i]);
                    }
                }
            });
        }
    }

    public <T> void decode(DynamicOps<T> ops, T input) {
        this.reset();
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        this.paused = ops.getBooleanValue(map.get("Paused")).result().orElse(false);
        this.completed = ops.getBooleanValue(map.get("Completed")).result().orElse(false);
        this.isAutoSchedule = ops.getBooleanValue(map.get("AutoSchedule")).result().orElse(false);
        this.currentEntry = Math.max(0, ops.getNumberValue(map.get("CurrentEntry"), (Number)0).intValue());
        Optional.ofNullable(map.get("Schedule")).ifPresent(scheduleView -> {
            this.schedule = Schedule.decode(ops, scheduleView);
        });
        this.state = State.CODEC.parse(ops, map.get("State")).result().orElse(State.PRE_TRANSIT);
        ops.getIntStream(map.get("ConditionProgress")).ifSuccess(stream -> stream.forEach(i -> this.conditionProgress.add(i)));
        CreateCodecs.NBT_COMPOUND_LIST_CODEC.parse(ops, map.get("ConditionContext")).ifSuccess(list -> this.conditionContext.addAll((Collection<class_2487>)list));
        if (this.schedule != null) {
            this.schedule.entries.forEach($ -> this.predictionTicks.add(-1));
            ops.getIntStream(map.get("TransitTimes")).ifSuccess(stream -> {
                int[] readTransits = stream.toArray();
                if (readTransits.length == this.schedule.entries.size()) {
                    for (int i = 0; i < readTransits.length; ++i) {
                        this.predictionTicks.set(i, readTransits[i]);
                    }
                }
            });
        }
    }

    public class_1799 returnSchedule(class_7225.class_7874 registries) {
        if (this.schedule == null) {
            return class_1799.field_8037;
        }
        class_1799 stack = AllItems.SCHEDULE.method_7854();
        this.schedule.savedProgress = this.currentEntry;
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "Schedule", Create.LOGGER);){
            class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)registries);
            this.schedule.write((class_11372)view);
            stack.method_57379(AllDataComponents.TRAIN_SCHEDULE, (Object)view.method_71475());
        }
        stack = this.isAutoSchedule ? class_1799.field_8037 : stack;
        this.discardSchedule();
        return stack;
    }

    public void setSchedulePresentClientside(boolean present) {
        this.schedule = present ? new Schedule() : null;
    }

    public class_5250 getWaitingStatus(class_1937 level) {
        List<List<ScheduleWaitCondition>> conditions = this.schedule.entries.get((int)this.currentEntry).conditions;
        if (conditions.isEmpty() || this.conditionProgress.isEmpty() || this.conditionContext.isEmpty()) {
            return class_2561.method_43473();
        }
        List<ScheduleWaitCondition> list = conditions.getFirst();
        int progress = this.conditionProgress.getFirst();
        if (progress >= list.size()) {
            return class_2561.method_43473();
        }
        class_2487 tag = this.conditionContext.getFirst();
        ScheduleWaitCondition condition = list.get(progress);
        return condition.getWaitingStatus(level, this.train, tag);
    }

    public static enum State implements class_3542
    {
        PRE_TRANSIT,
        IN_TRANSIT,
        POST_TRANSIT;

        public static final Codec<State> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(State::values);
        }
    }
}

